[Setup]
;-- Main Setup Information
 AppName                  = SQL-Exchange Server
 AppVerName               = SQL-Exchange Server 1.0.3.4
 AppCopyright             = Copyright  1995-2004 NetWorkDLS
 DefaultDirName           = {pf}\NetWorkDLS\SQL-Exchange\Server
 DefaultGroupName         = NetWorkDLS\SQL-Exchange Server
 UninstallDisplayIcon     = {app}\SQLEServer.Exe
 UninstallStyle           = Modern
 WizardImageFile          = Resources\LgSetup.bmp
 WizardSmallImageFile     = Resources\SmSetup.bmp
 PrivilegesRequired       = PowerUser
 Uninstallable            = Yes
 AppMutex                 = SQL-Exchange Server
 LicenseFile              = Resources\EULA.txt
 Compression              = BZIP/9
 OutputBaseFilename       = SQLEServer 1.0.3.4
;UninstallLogMode         = OverWrite
 UninstallRestartComputer = Yes
 DisableStartupPrompt     = Yes
 DirExistsWarning         = No

;-- Windows 2000 & XP (Support Dialog)
 AppPublisher    = NetWorkDLS
 AppPublisherURL = http://www.NetWorkDLS.com/
 AppUpdatesURL   = http://www.NetWorkDLS.com/
 AppVersion      = 1.0.3.4

[Files]
 Source: "..\Debug\SQLEServer.Exe";           DestDir: "{app}"; Flags: IgnoreVersion RestartReplace;
 Source: "ServiceCtl\Release\ServiceCtl.Exe"; DestDir: "{app}"; Flags: IgnoreVersion;

 Source: "Resources\EULA.txt";                DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Resources\OpenDlg.ico";             DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Resources\Start.ico";               DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Resources\Stop.ico";                DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Resources\OpenCon.ico";             DestDir: "{app}"; Flags: IgnoreVersion;

 Source: "SQL\SQLExch_Statements.sql";        DestDir: "{app}\SQL"; Flags: IgnoreVersion;

 Source: "Libraries\NSWFL.Dll";               DestDir: "{app}"; Flags: RestartReplace;

[Icons]
 Name: "{group}\Open Server";     Filename: "{app}\ServiceCtl.Exe";  WorkingDir: "{app}"; Parameters: "/OpenMainDialog"; IconFilename: "{app}\OpenDlg.ico"
 Name: "{group}\Open Console";    Filename: "{app}\ServiceCtl.Exe";  WorkingDir: "{app}"; Parameters: "/OpenConsole";    IconFilename: "{app}\OpenCon.ico"
 Name: "{group}\Start Service";   Filename: "{app}\ServiceCtl.Exe";  WorkingDir: "{app}"; Parameters: "/Start";          IconFilename: "{app}\Start.ico"
 Name: "{group}\Stop Service";    Filename: "{app}\ServiceCtl.Exe";  WorkingDir: "{app}"; Parameters: "/Stop";           IconFilename: "{app}\Stop.ico"
 Name: "{group}\Run StandAlone";  Filename: "{app}\SQLEServer.Exe";  WorkingDir: "{app}"; Parameters: "/NonService";     IconFilename: "{app}\OpenDlg.ico"

[Dirs]
 Name: "{app}\Logs"

[Registry]
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; Flags: UninsDeleteKey

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "Path";               ValueType: String; ValueData: "{app}";           Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "SessionLogDir";      ValueType: String; ValueData: "{app}\Logs";      Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "SQLDataFiles";       ValueType: String; ValueData: "C:\Program Files\Microsoft SQL Server\MSSQL\Data"; Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "DefaultDBO";         ValueType: String; ValueData: "DBO";             Flags: CreateValueIfDoesntExist;
 
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "AuthString";         ValueType: String; ValueData: "trIeSPiUhouDlUwRLe5hie2H5awRoupiaDi8zI0fo3Y7u6R703r7e6rLacrouChi";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "AuthKey";            ValueType: String; ValueData: "6riupiekieB8uphiuspi0tr6azl2piAth6us6ieko2zoap2818UviapHlEvo5joe";

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "ImportTempDir";      ValueType: String; ValueData: "{app}\CFTemp";

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "SQLIndexDatabase";   ValueType: String; ValueData: "SQLExch_Index";   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "SQLIndexDriver";     ValueType: String; ValueData: "{{SQL Server}";   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "SQLIndexPassword";   ValueType: String; ValueData: "";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "SQLIndexServer";     ValueType: String; ValueData: "";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "SQLIndexUserID";     ValueType: String; ValueData: "sa";              Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "SQLCustDriver";      ValueType: String; ValueData: "{{SQL Server}";   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "SQLCustPassword";    ValueType: String; ValueData: "";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "SQLCustServer";      ValueType: String; ValueData: "";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "SQLCustUserID";      ValueType: String; ValueData: "sa";              Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "ListenPort";         ValueType: Dword;  ValueData: "6637";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "MaxClients";         ValueType: Dword;  ValueData: "10";              Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "TCPLoopDelay";       ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "ShowSplashScreen";   ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "StartAutomatically"; ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "DropBadPackets";     ValueType: Dword;  ValueData: "0";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "HashTimeoutMS";      ValueType: Dword;  ValueData: "1000";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "KeyGenLength";       ValueType: Dword;  ValueData: "128";             Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "NextClientID";       ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "PacketMode";         ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "PingTimeoutMS";      ValueType: Dword;  ValueData: "60000";           Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "RawHashLen";         ValueType: Dword;  ValueData: "32";              Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Server"; ValueName: "UseCompression";     ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;

[Run]
 Filename: "{app}\ServiceCtl.EXE"; Parameters: "/install";
 Filename: "{app}\ServiceCtl.EXE"; Parameters: "/start";

[UninstallRun]
 Filename: "{app}\ServiceCtl.EXE"; Parameters: "/delete"; RunOnceId: "DeleteService"; MinVersion: 0, 4.0

